Slider = copy_table(Bitmap)

function Slider:init(def, view)
    Bitmap.init(self, def, view)

    self.bitmap_full = gfx_load_bitmap(def.bitmap_full)
    self.bitmap_button = gfx_load_bitmap(def.bitmap_button)
    self.level = 0
    self.area_w = self.area.x1 - self.area.x0
    
    if def.on_change then
        self.call_on_change = view[def.on_change]
    end
end


function Slider:destroy()
    gfx_release_bitmap(self.bitmap_full)
    gfx_release_bitmap(self.bitmap_button)
    Bitmap.destroy(self)
end


function Slider:set_level(level)
    self.level = self.area_w * level
end


function Slider:get_level()
    return self.level / self.area_w
end


function Slider:mouse_left_down()
    self.level = (mouse.x - self.x) - self.area.x0
    if self.call_on_change then
        self.call_on_change(self.view, self)
    end
end


function Slider:render()
    gfx_render_sprite(self.bitmap, "main", self.x, self.y, 1)
    gfx_crop_sprite(0, 0, -(self.area_w - self.level + self.w - self.area.x1), 0)
    gfx_render_sprite(self.bitmap_full, "main", self.x, self.y, 1)
    gfx_render_sprite(self.bitmap_button, "main", self.x + self.level + self.area.x0, self.y, 1)
end
